/******************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audioroutemanager.cpp
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audioroutemanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
*******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
/* Include AudioRoute Manager FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include "midw_fi_if.h"

#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "CAmControlSenderBase.h"


/* Needed for Trace */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

//#include "common.h"
#include "cca_if.h"
#include "shared/CAmDltWrapper.h"

//tBool amcontrol_clienthandler_fc_audioroutemanager::bServiceAvailable = false;

/*******************************************************************************
                  Specific defines for this component
*******************************************************************************/
DLT_DECLARE_CONTEXT(ClientFCAudioRouteMgr)

/*******************************************************************************
                  Message map for FunctionIDs to be handled
*******************************************************************************/
BEGIN_MSG_MAP(amcontrol_clienthandler_fc_audioroutemanager, inc_fi_handler)
  ON_MESSAGE(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY, vOnSourceRouteActivity)
  ON_MESSAGE(MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE, vOnRequestAudioRoute)
END_MSG_MAP()

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audioroutemanager
 *DESCRIPTION  : constructor for class amcontrol_clienthandler_fc_audioroutemanager
 *PARAMETER    : am::IAmRoutingReceiverShadow*
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audioroutemanager::amcontrol_clienthandler_fc_audioroutemanager(CAmControlSenderBase* pControlSenderBase,am::IAmControlReceiverShadow* pControlReceiver)
   : m_pControlSenderBase(pControlSenderBase),m_pControlReceiverShadowInterface(pControlReceiver),m_RoutingReadyHandle(0),inc_fi_handler(
                          CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR                 // Application Id
               , MIDW_AUDIO_ROUTE_MGRFI_C_U16_SERVICE_ID             // Service Id
               , MIDW_AUDIO_ROUTE_MGRFI_C_U16_SERVICE_MAJORVERSION     // MajorVersion of Service
               , MIDW_AUDIO_ROUTE_MGRFI_C_U16_SERVICE_MINORVERSION     // MinorVersion of Service
               )

{
   log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"Entered in constructor amcontrol_clienthandler_fc_audioroutemanager()");
   m_bSeviceAvailable = false;
   CAmDltWrapper::instance()->registerContext(ClientFCAudioRouteMgr, "CLRM", "ClientHandler for FCAudioRouteManager");
   bRegisterForFID(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY);
}

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audioroutemanager
 *DESCRIPTION  : destructor for class amcontrol_clienthandler_fc_audioroutemanager
 *PARAMETER    : void
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audioroutemanager::~amcontrol_clienthandler_fc_audioroutemanager(void)
{
   log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"Entered in destructor amcontrol_clienthandler_fc_audioroutemanager()");
   bUnRegisterForFID(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY);
}

/************************************************************************
 *FUNCTION     : vOnSourceAvailability
 *DESCRIPTION  : callback for property SourceAvailability
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *28.11.2013   Rev 1.0     R.Volkmer
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audioroutemanager::vOnSourceAvailability(amt_tclServiceData* poMessage)
{
  log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"entered in vOnSourceAvailability,Received AudioRouteList from ARL");

  if ( poMessage != OSAL_NULL )
  {
    switch (poMessage->u8GetOpCode())
    {
     case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
      break;
     }
     case AMT_C_U8_CCAMSG_OPCODE_STATUS:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceAvailability opcode:AMT_C_U8_CCAMSG_OPCODE_STATUS");

      midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus oSourceAvailableStatus;

      //Get the data using Helper function
      vCopyDatatoFIMessage(poMessage,oSourceAvailableStatus);

      bpstl::vector<midw_fi_tcl_SourceAvailablityItem>::const_iterator SrcAvailIterator;

      if(oSourceAvailableStatus.SourceAvailabilityList.empty())
      {
        log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceAvailability,SourceAvailabilityList is empty");
      }
      else
      {
        for(SrcAvailIterator = oSourceAvailableStatus.SourceAvailabilityList.begin();
              SrcAvailIterator != oSourceAvailableStatus.SourceAvailabilityList.end();
              ++SrcAvailIterator)
         {
           tU8 Source = (tU8)(*SrcAvailIterator).u8Source.enType;
           tU16 SubSource = (tU16)(*SrcAvailIterator).u16SubSource;
           tU8 Availability = (tU8)(*SrcAvailIterator).e8Availability.enType;
           tU8 Reason = (tU8)(*SrcAvailIterator).e8Reason.enType;

           log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute,Received AudioRouteList Item:",Source,"Sub:",SubSource,",Availability:",Availability,
                     ",Reason:",Reason);
         }
      }

      if(m_pControlReceiverShadowInterface)
      {
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute->Status  received,Inserting AudioRoute Response");
         m_pControlReceiverShadowInterface->insert_queue(poMessage);
         m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
      }
      break;
     }
     case AMT_C_U8_CCAMSG_OPCODE_ERROR:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:AMT_C_U8_CCAMSG_OPCODE_ERROR");
      break;
     }
     default:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:Unknown");
      break;
     }
    }
  }
  else
  {
    log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute -->poMessage = OSAL_NULL");
  }
}

/************************************************************************
 *FUNCTION     : vOnSourceRouteActivity
 *DESCRIPTION  : callback for property SourceRouteActivity
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audioroutemanager::vOnSourceRouteActivity(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"entered in vOnSourceRouteActivity");

   if ( poMessage != OSAL_NULL )
   {
      switch (poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity opcode:AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity opcode:AMT_C_U8_CCAMSG_OPCODE_STATUS");
            midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus oSrcRouteActStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oSrcRouteActStatus);
            log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity,source",oSrcRouteActStatus.SourceRouteActivity.Source.enType,
                  ",PossibleNextSource:",oSrcRouteActStatus.SourceRouteActivity.PossibleNextSource.enType,
                  ",Resource:",oSrcRouteActStatus.SourceRouteActivity.Resource.enType,
                  ",Activity:",oSrcRouteActStatus.SourceRouteActivity.Activity.enType);

            if(m_pControlReceiverShadowInterface)
            {
              log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity->Status  received,Inserting SourceRouteActivity Response touched");
              m_pControlReceiverShadowInterface->insert_queue(poMessage);
              m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            break;
         }

         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity opcode:AMT_C_U8_CCAMSG_OPCODE_ERROR");

            if(m_pControlReceiverShadowInterface)
            {
              log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity->Status  received,Inserting SourceRouteActivity Response touched");
              m_pControlReceiverShadowInterface->insert_queue(poMessage);
              m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            break;
         }
         default:
         {
            log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity opcode:Unknown");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnSourceRouteActivity -->poMessage = OSAL_NULL");
   }
}

/************************************************************************
 *FUNCTION     : vOnRequestAudioRoute
 *DESCRIPTION  : callback for property RequestAudioRoute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *10.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid amcontrol_clienthandler_fc_audioroutemanager::vOnRequestAudioRoute(amt_tclServiceData* poMessage)
{
  log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"entered in vOnRequestAudioRoute,Received AudioRouteList from ARL");

  if ( poMessage != OSAL_NULL )
  {
    switch (poMessage->u8GetOpCode())
    {
     case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
      break;
     }
     case AMT_C_U8_CCAMSG_OPCODE_STATUS:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:AMT_C_U8_CCAMSG_OPCODE_STATUS");

      midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus oAudioRouteStatus;

      //Get the data using Helper function
      vCopyDatatoFIMessage(poMessage,oAudioRouteStatus);

      bpstl::vector<midw_fi_tcl_RequestAudioRouteItem>::const_iterator ReqRouteIterator;

      if(oAudioRouteStatus.RequestAudioRouteList.empty())
      {
        log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute,RequestAudioRouteList is empty");
      }
      else
      {
        for(ReqRouteIterator = oAudioRouteStatus.RequestAudioRouteList.begin();
                 ReqRouteIterator != oAudioRouteStatus.RequestAudioRouteList.end();
                    ++ReqRouteIterator)
         {
           tU8 Source = (tU8)(*ReqRouteIterator).u8Source.enType;
           tU16 Activity = (tU16)(*ReqRouteIterator).e8Activity.enType;
           tU8 Reason = (tU8)(*ReqRouteIterator).u8Reason;

           log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute,Received AudioRouteList :",Source,",Activity:",Activity,
                     ",Reason:",Reason);
         }
      }

      if(m_pControlReceiverShadowInterface)
      {
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute->Status  received,Inserting AudioRoute Response");
         m_pControlReceiverShadowInterface->insert_queue(poMessage);
         m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
      }
      break;
     }
     case AMT_C_U8_CCAMSG_OPCODE_ERROR:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:AMT_C_U8_CCAMSG_OPCODE_ERROR");
      break;
     }
     default:
     {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute opcode:Unknown");
      break;
     }
    }
  }
  else
  {
    log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vOnRequestAudioRoute -->poMessage = OSAL_NULL");
  }
}

/*******************************************************************************
               Methods of this application
*******************************************************************************/

/************************************************************************
 *FUNCTION     : vSourceRouteActivity_Set
 *DESCRIPTION  : function to set property SourceRouteActivity
 *PARAMETER    : uint8_t,uint8_t,uint8_t,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audioroutemanager::vSourceRouteActivity_Set(uint8_t u8Source,uint8_t u8NextSource,uint8_t u8Resource,uint8_t u8Activity)
{
   log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"entered in vSourceRouteActivity_Set,source:",u8Source,
      "u8NextSource:",u8NextSource,"u8Resource:",u8Resource,"u8Activity:",u8Activity);

   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet oFiDataObject1;

      // Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SourceRouteActivity.Source.enType = (midw_fi_tcl_e8_AudSource::tenType) u8Source;
      oFiDataObject1.SourceRouteActivity.PossibleNextSource.enType = (midw_fi_tcl_e8_AudSource::tenType) u8NextSource;
      oFiDataObject1.SourceRouteActivity.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.SourceRouteActivity.Activity.enType = (midw_fi_tcl_e8_SrcActivity::tenType) u8Activity;

      bool enResult = bPostFIMessage(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY,
                                 AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vSourceRouteActivity_Set:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"vSourceRouteActivity_Set:Succeded PostMessage");
      }
   }
}

tVoid amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable()
{
   log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"Entered amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable");

   if(m_pControlReceiverShadowInterface)
   {
      m_pControlReceiverShadowInterface->m_bServiceReady_fcAudioRouteMgr = true;
      if((false == m_pControlReceiverShadowInterface->m_bControllerReady) &&
            (true == m_pControlReceiverShadowInterface->m_bServiceReady_fcAudioMgr) &&
            (true == m_pControlReceiverShadowInterface->m_bRoutingReady))
      {
         m_pControlReceiverShadowInterface->m_bControllerReady = true;
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable,Calling confirmControllerReady");
         m_pControlReceiverShadowInterface->confirmControllerReady(E_OK);
         m_pControlSenderBase->InitStackManager();
      }
      else
         log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable,already sent confirmControllerReady OR \
            waiting for serivice fcAudioMgr..OR waiting for confirmRoutingReady");
   }
   else
   {
      log(&ClientFCAudioRouteMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audioroutemanager::vOnServiceAvailable, m_pReceiverShadowInterface is NULL");
   }
}
/**
* wrapper function to copy the data from a FI Message to amt_tclServiceData
*/
void amcontrol_clienthandler_fc_audioroutemanager::vCopyDatatoFIMessageWrapper(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData)
{
   vCopyDatatoFIMessage(poFIMsg,oFIData);
}
